/******************************************************************************
*                       Software License Agreement                            *
*                                                                             *
*   The software supplied herewith by Microchip Technology Incorporated       *
*   (the "Company") for its dsPIC controller is intended and supplied to      *
*   you, the Company's customer, for use solely and exclusively on            *
*   Microchip dsPIC products. The software is owned by the Company and/or     *
*   its supplier, and is protected under applicable copyright laws. All       *
*   rights are reserved. Any use in violation of the foregoing                *
*   restrictions may subject the user to criminal sanctions under             *
*   applicable laws, as well as to civil liability for the breach of the      *
*   terms and conditions of this license.                                     *
*                                                                             *
*   THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION.  NO WARRANTIES,        *
*   WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED TO,     *
*   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR        *
*   PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, IN ANY             *
*   CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR CONSEQUENTIAL         *
*   DAMAGES, FOR ANY REASON WHATSOEVER.                                       *
*                                                                             *
*******************************************************************************
*                                                                             *
*   Decode manchester coded data from an Input Capture interrupt routine      *
*   and output the decoded text to the UART.                                  *
*                                                                             *
******************************************************************************/

#include "p30F6014.h"
#include "stdio.h"

unsigned int __attribute__((aligned(64))) DataBuffer[32];
register unsigned int *InBufferPointer asm ("w8");
register unsigned int IC1BUFpointer asm ("w9");
register unsigned int *OutBufferPointer asm("w10");
unsigned int PreviousCapture,NewCapture,TimeDifference;
unsigned int BitTimeThreshold = 75;
unsigned int DataWord,DataMask;

union
{
  struct
  {
    int BitValue:1;
    int HalfBit:1;
  } Bit;
  unsigned int Word;
} BitVars;

//struct BitField {
//    int BitValue:1;
//    int HalfBit:1;
//} BitVars;

//unsigned int BitValue = 0, HalfBit = 1;

int main (void)
{
    InBufferPointer = &DataBuffer[0];
    OutBufferPointer = &DataBuffer[0];
    IC1BUFpointer = (unsigned int)&IC1BUF;
    BitVars.Bit.BitValue = 0;
    BitVars.Bit.HalfBit = 1;

    IC1CON = 0x0081;                //Set up Input Capture 1
    T2CON = 0x8000;                 //Set up Timer 2

    IFS0bits.IC1IF = 0;             //Clear IC1 interrupt flag
    IEC0bits.IC1IE = 1;             //Enable IC1 interrupt

    XMODSRT = (unsigned int)&DataBuffer[0];
    XMODEND = (unsigned int)&DataBuffer[32] - 1;
    MODCON = 0x8008;                //Enable modulo addressing for W8

    U1BRG = 0;                      //Calculate UxBRG for 20MHz
    U1MODE = 0x8000;                //Enable UART and disable auto baud detection
    U1STA = 0x0400;                 //Enable transmission

    while(InBufferPointer == OutBufferPointer){}
    PreviousCapture = *(OutBufferPointer++);
    DataMask = 0x0100;

    while(1)
    {    
        while(InBufferPointer != OutBufferPointer)
        {
            NewCapture = *(OutBufferPointer++);
            TimeDifference = NewCapture - PreviousCapture;
            PreviousCapture = NewCapture;
            if(OutBufferPointer > &DataBuffer[31])
                OutBufferPointer = &DataBuffer[0];
            if(TimeDifference > BitTimeThreshold)
            {
                __builtin_btg(&BitVars.Word,BitVars.Bit.BitValue);
                BitTimeThreshold = (TimeDifference * 3) >> 2;
                if(BitVars.Bit.BitValue)
                    DataWord |= DataMask;
                if(DataMask == 0)
                {
                    U1TXREG = DataWord;
                    DataMask = 0x0200;
                    DataWord = 0;
                }
                DataMask = DataMask >> 1;
            }
            else
            {
                if(BitVars.Bit.HalfBit == 0)
                    BitVars.Bit.HalfBit = 1;
                else
                {
                    BitVars.Bit.HalfBit = 0;
                    if(BitVars.Bit.BitValue)
                        DataWord |= DataMask;
                    if(DataMask == 0)
                    {
                        U1TXREG = DataWord;
                        DataMask = 0x0200;
                        DataWord = 0;
                    }
                    DataMask = DataMask >> 1;
                }
            }

        }
    }
}

//---------------------------------------------------------------------------

